/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.modeloverride;

import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import tschipp.carryon.Constants;
import tschipp.carryon.client.modeloverride.ModelOverride;

public class ModelOverrideHandler {
    private static List<ModelOverride> OVERRIDES = new ArrayList<ModelOverride>();

    public static void initModelOverrides() {
        OVERRIDES.clear();
        for (String ov : Constants.CLIENT_CONFIG.modelOverrides) {
            ModelOverrideHandler.addFromString(ov);
        }
    }

    public static Optional<ModelOverride> getModelOverride(BlockState state, @Nullable CompoundTag tag) {
        for (ModelOverride ov : OVERRIDES) {
            if (!ov.matches(state, tag)) continue;
            return Optional.of(ov);
        }
        return Optional.empty();
    }

    public static void addFromString(String str) {
        DataResult<ModelOverride> res = ModelOverride.of(str);
        if (res.result().isPresent()) {
            ModelOverride override = (ModelOverride)res.result().get();
            OVERRIDES.add(override);
        } else {
            Constants.LOG.debug("Error while parsing ModelOverride: " + ((DataResult.PartialResult)res.error().get()).message());
        }
    }
}

